--[[
  TranslationKeys.lua
  Label Sync Plugin - Master Translation Table
  
  全ての翻訳キーを一元管理するマスターテーブル。
  新しいキーを追加する際は、このファイルのみを編集してください。
  
  構造: キー名 = { 言語コード = "翻訳文字列", ... }
  
  対応言語:
  - ja: 日本語
  - en: English  
  - ko: 한국어
  - fr: Français
  - es: Español
  - de: Deutsch
  - zh-Hans: 简体中文
  - zh-Hant: 繁體中文
  - da: Dansk
--]]

local TranslationKeys = {

  -- ========================================
  -- メニュー項目
  -- ========================================
  menu_main = {
    ja = "Label Sync…",
    en = "Label Sync…",
    ko = "Label Sync…",
    fr = "Label Sync…",
    es = "Label Sync…",
    de = "Label Sync…",
    ["zh-Hans"] = "Label Sync…",
    ["zh-Hant"] = "Label Sync…",
    da = "Label Sync…",
  },
  menu_activation = {
    ja = "Label Sync – 認証…",
    en = "Label Sync – Activation…",
    ko = "Label Sync – 활성화…",
    fr = "Label Sync – Activation…",
    es = "Label Sync – Activación…",
    de = "Label Sync – Aktivierung…",
    ["zh-Hans"] = "Label Sync – 激活…",
    ["zh-Hant"] = "Label Sync – 啟用…",
    da = "Label Sync – Aktivering…",
  },

  -- ========================================
  -- メインダイアログ
  -- ========================================
  dialog_title = {
    ja = "Label Sync",
    en = "Label Sync",
    ko = "Label Sync",
    fr = "Label Sync",
    es = "Label Sync",
    de = "Label Sync",
    ["zh-Hans"] = "Label Sync",
    ["zh-Hant"] = "Label Sync",
    da = "Label Sync",
  },
  label_selection_list = {
    ja = "セレクションリスト (CSV/TSV):",
    en = "Selection List:",
    ko = "셀렉션 리스트:",
    fr = "Liste de sélection:",
    es = "Lista de selección:",
    de = "Auswahlliste:",
    ["zh-Hans"] = "选择列表:",
    ["zh-Hant"] = "選擇清單:",
    da = "Udvælgelsesliste:",
  },
  button_load_file = {
    ja = "ファイルから読み込む…",
    en = "Load from File…",
    ko = "파일에서 불러오기…",
    fr = "Charger depuis un fichier…",
    es = "Cargar desde archivo…",
    de = "Aus Datei laden…",
    ["zh-Hans"] = "从文件加载…",
    ["zh-Hant"] = "從檔案載入…",
    da = "Indlæs fra fil…",
  },
  button_preview = {
    ja = "プレビュー",
    en = "Preview",
    ko = "미리보기",
    fr = "Aperçu",
    es = "Vista previa",
    de = "Vorschau",
    ["zh-Hans"] = "预览",
    ["zh-Hant"] = "預覽",
    da = "Forhåndsvisning",
  },
  button_sync = {
    ja = "ラベルを反映",
    en = "Sync Now",
    ko = "동기화",
    fr = "Synchroniser",
    es = "Sincronizar",
    de = "Synchronisieren",
    ["zh-Hans"] = "同步",
    ["zh-Hant"] = "同步",
    da = "Synkroniser",
  },
  button_cancel = {
    ja = "キャンセル",
    en = "Cancel",
    ko = "취소",
    fr = "Annuler",
    es = "Cancelar",
    de = "Abbrechen",
    ["zh-Hans"] = "取消",
    ["zh-Hant"] = "取消",
    da = "Annuller",
  },
  placeholder_paste_here = {
    ja = "【サンプル形式】\nファイル名\tレーティング\tラベル\tキャプチャ時間\nIMG_0001.JPG\t★★★★★\tRed\t2024/12/25 10:30:00\nIMG_0002.JPG\t★★★\tGreen\t2024/12/25 10:31:00",
    en = "[Sample Format]\nFilename\tRating\tLabel\tCapture Time\nIMG_0001.JPG\t★★★★★\tRed\t2024/12/25 10:30:00\nIMG_0002.JPG\t★★★\tGreen\t2024/12/25 10:31:00",
    ko = "[샘플 형식]\n파일명\t레이팅\t라벨\t촬영시간\nIMG_0001.JPG\t★★★★★\tRed\t2024/12/25 10:30:00\nIMG_0002.JPG\t★★★\tGreen\t2024/12/25 10:31:00",
    fr = "[Format exemple]\nNom de fichier\tNote\tLibellé\tHeure de capture\nIMG_0001.JPG\t★★★★★\tRed\t2024/12/25 10:30:00\nIMG_0002.JPG\t★★★\tGreen\t2024/12/25 10:31:00",
    es = "[Formato de ejemplo]\nNombre de archivo\tCalificación\tEtiqueta\tHora de captura\nIMG_0001.JPG\t★★★★★\tRed\t2024/12/25 10:30:00\nIMG_0002.JPG\t★★★\tGreen\t2024/12/25 10:31:00",
    de = "[Beispielformat]\nDateiname\tBewertung\tLabel\tAufnahmezeit\nIMG_0001.JPG\t★★★★★\tRed\t2024/12/25 10:30:00\nIMG_0002.JPG\t★★★\tGreen\t2024/12/25 10:31:00",
    ["zh-Hans"] = "[示例格式]\n文件名\t评级\t标签\t拍摄时间\nIMG_0001.JPG\t★★★★★\tRed\t2024/12/25 10:30:00\nIMG_0002.JPG\t★★★\tGreen\t2024/12/25 10:31:00",
    ["zh-Hant"] = "[範例格式]\n檔案名稱\t評級\t標籤\t拍攝時間\nIMG_0001.JPG\t★★★★★\tRed\t2024/12/25 10:30:00\nIMG_0002.JPG\t★★★\tGreen\t2024/12/25 10:31:00",
    da = "[Eksempelformat]\nFilnavn\tVurdering\tLabel\tOptagetid\nIMG_0001.JPG\t★★★★★\tRed\t2024/12/25 10:30:00\nIMG_0002.JPG\t★★★\tGreen\t2024/12/25 10:31:00",
  },
  sample_format_hint = {
    ja = "形式: ファイル名 | レーティング | ラベル | キャプチャ時間",
    en = "Format: Filename | Rating | Label | Capture Time",
    ko = "형식: 파일명 | 레이팅 | 라벨 | 촬영시간",
    fr = "Format: Nom de fichier | Note | Libellé | Heure de capture",
    es = "Formato: Nombre | Calificación | Etiqueta | Hora",
    de = "Format: Dateiname | Bewertung | Label | Aufnahmezeit",
    ["zh-Hans"] = "格式: 文件名 | 评级 | 标签 | 拍摄时间",
    ["zh-Hant"] = "格式: 檔名 | 評級 | 標籤 | 拍攝時間",
    da = "Format: Filnavn | Vurdering | Label | Optagetid",
  },
  
  -- ========================================
  -- ヘルプダイアログ（Shutter Snitch 設定ガイド）
  -- ========================================
  help_button_title = {
    ja = "?",
    en = "?",
    ko = "?",
    fr = "?",
    es = "?",
    de = "?",
    ["zh-Hans"] = "?",
    ["zh-Hant"] = "?",
    da = "?",
  },
  help_dialog_title = {
    ja = "Shutter Snitch 設定ガイド",
    en = "Shutter Snitch Setup Guide",
    ko = "Shutter Snitch 설정 가이드",
    fr = "Guide de configuration Shutter Snitch",
    es = "Guía de configuración de Shutter Snitch",
    de = "Shutter Snitch Einrichtungsanleitung",
    ["zh-Hans"] = "Shutter Snitch 设置指南",
    ["zh-Hant"] = "Shutter Snitch 設定指南",
    da = "Shutter Snitch opsætningsvejledning",
  },
  help_dialog_content = {
    ja = "【Shutter Snitch でのリスト書き出し設定】\n\n設定 > リスト / LIGHTROOM CLASSIC PLUG-IN で\n以下の項目を必ず有効にしてください：\n\n✅ ファイル名（必須）\n✅ レーティング（必須）\n✅ ラベル（推奨）\n✅ キャプチャ時間（PTP/IPモード時は必須）\n\n共有フォーマット：CSVまたはプレーンテキスト",
    en = "[Shutter Snitch List Export Settings]\n\nIn Settings > List / LIGHTROOM CLASSIC PLUG-IN,\nplease enable the following columns:\n\n✅ Filename (Required)\n✅ Rating (Required)\n✅ Label (Recommended)\n✅ Capture Time (Required for PTP/IP mode)\n\nShare Format: CSV or Plain Text",
    ko = "[Shutter Snitch 목록 내보내기 설정]\n\n설정 > 목록 / LIGHTROOM CLASSIC PLUG-IN에서\n다음 항목을 활성화하세요:\n\n✅ 파일명 (필수)\n✅ 레이팅 (필수)\n✅ 라벨 (권장)\n✅ 촬영시간 (PTP/IP 모드 시 필수)\n\n공유 형식: CSV 또는 일반 텍스트",
    fr = "[Paramètres d'export Shutter Snitch]\n\nDans Réglages > Liste / LIGHTROOM CLASSIC PLUG-IN,\nactivez les colonnes suivantes :\n\n✅ Nom de fichier (Obligatoire)\n✅ Note (Obligatoire)\n✅ Libellé (Recommandé)\n✅ Heure de capture (Obligatoire en mode PTP/IP)\n\nFormat de partage : CSV ou Texte brut",
    es = "[Configuración de exportación de Shutter Snitch]\n\nEn Ajustes > Lista / LIGHTROOM CLASSIC PLUG-IN,\nhabilite las siguientes columnas:\n\n✅ Nombre de archivo (Obligatorio)\n✅ Calificación (Obligatorio)\n✅ Etiqueta (Recomendado)\n✅ Hora de captura (Obligatorio en modo PTP/IP)\n\nFormato de compartir: CSV o Texto sin formato",
    de = "[Shutter Snitch Listenexport-Einstellungen]\n\nUnter Einstellungen > Liste / LIGHTROOM CLASSIC PLUG-IN\naktivieren Sie folgende Spalten:\n\n✅ Dateiname (Erforderlich)\n✅ Bewertung (Erforderlich)\n✅ Label (Empfohlen)\n✅ Aufnahmezeit (Erforderlich für PTP/IP-Modus)\n\nFreigabeformat: CSV oder Klartext",
    ["zh-Hans"] = "[Shutter Snitch 列表导出设置]\n\n在 设置 > 列表 / LIGHTROOM CLASSIC PLUG-IN 中\n请启用以下列：\n\n✅ 文件名（必需）\n✅ 评级（必需）\n✅ 标签（推荐）\n✅ 拍摄时间（PTP/IP 模式时必需）\n\n共享格式：CSV 或 纯文本",
    ["zh-Hant"] = "[Shutter Snitch 清單匯出設定]\n\n在 設定 > 清單 / LIGHTROOM CLASSIC PLUG-IN 中\n請啟用以下欄位：\n\n✅ 檔案名稱（必要）\n✅ 評級（必要）\n✅ 標籤（建議）\n✅ 拍攝時間（PTP/IP 模式時必要）\n\n共享格式：CSV 或 純文字",
    da = "[Shutter Snitch listeeksport-indstillinger]\n\nUnder Indstillinger > Liste / LIGHTROOM CLASSIC PLUG-IN\naktiver følgende kolonner:\n\n✅ Filnavn (Påkrævet)\n✅ Vurdering (Påkrævet)\n✅ Label (Anbefalet)\n✅ Optagetid (Påkrævet for PTP/IP-tilstand)\n\nDelingsformat: CSV eller Almindelig tekst",
  },

  -- ========================================
  -- プレビュー結果
  -- ========================================
  preview_title = {
    ja = "プレビュー結果",
    en = "Preview Results",
    ko = "미리보기 결과",
    fr = "Résultats de l'aperçu",
    es = "Resultados de la vista previa",
    de = "Vorschau-Ergebnisse",
    ["zh-Hans"] = "预览结果",
    ["zh-Hant"] = "預覽結果",
    da = "Forhåndsvisningsresultater",
  },
  preview_matched_filename = {
    ja = "ファイル名一致:",
    en = "Matched (filename):",
    ko = "파일명 일치:",
    fr = "Correspondance (nom de fichier):",
    es = "Coincidencia (nombre de archivo):",
    de = "Übereinstimmung (Dateiname):",
    ["zh-Hans"] = "文件名匹配:",
    ["zh-Hant"] = "檔名匹配:",
    da = "Match (filnavn):",
  },
  preview_matched_time = {
    ja = "撮影時刻一致:",
    en = "Matched (time fallback):",
    ko = "촬영시간 일치:",
    fr = "Correspondance (heure):",
    es = "Coincidencia (hora):",
    de = "Übereinstimmung (Zeit):",
    ["zh-Hans"] = "拍摄时间匹配:",
    ["zh-Hant"] = "拍攝時間匹配:",
    da = "Match (tid):",
  },
  preview_unmatched = {
    ja = "不一致:",
    en = "Unmatched:",
    ko = "불일치:",
    fr = "Non trouvé:",
    es = "Sin coincidencia:",
    de = "Keine Übereinstimmung:",
    ["zh-Hans"] = "不匹配:",
    ["zh-Hant"] = "不匹配:",
    da = "Ingen match:",
  },
  preview_total = {
    ja = "合計:",
    en = "Total:",
    ko = "합계:",
    fr = "Total:",
    es = "Total:",
    de = "Gesamt:",
    ["zh-Hans"] = "总计:",
    ["zh-Hant"] = "總計:",
    da = "Total:",
  },

  -- ========================================
  -- 統計ラベル
  -- ========================================
  stat_section_title = {
    ja = "統計",
    en = "Statistics",
    ko = "통계",
    fr = "Statistiques",
    es = "Estadísticas",
    de = "Statistik",
    ["zh-Hans"] = "统计",
    ["zh-Hant"] = "統計",
    da = "Statistik",
  },
  stat_filename_match = {
    ja = "ファイル名一致:",
    en = "Filename match:",
    ko = "파일명 일치:",
    fr = "Correspondance nom:",
    es = "Coincidencia nombre:",
    de = "Dateiname stimmt:",
    ["zh-Hans"] = "文件名匹配:",
    ["zh-Hant"] = "檔名匹配:",
    da = "Filnavn match:",
  },
  stat_filename_mismatch = {
    ja = "ファイル名不一致:",
    en = "Filename mismatch:",
    ko = "파일명 불일치:",
    fr = "Non correspondant:",
    es = "Sin coincidencia:",
    de = "Keine Übereinstimmung:",
    ["zh-Hans"] = "文件名不匹配:",
    ["zh-Hant"] = "檔名不匹配:",
    da = "Filnavn ikke match:",
  },
  stat_time_match = {
    ja = "撮影時刻一致:",
    en = "Time match:",
    ko = "촬영시간 일치:",
    fr = "Correspondance heure:",
    es = "Coincidencia hora:",
    de = "Zeit stimmt:",
    ["zh-Hans"] = "拍摄时间匹配:",
    ["zh-Hant"] = "拍攝時間匹配:",
    da = "Tid match:",
  },
  stat_time_duplicate = {
    ja = "撮影時刻重複:",
    en = "Time duplicates:",
    ko = "촬영시간 중복:",
    fr = "Doublons (heure):",
    es = "Duplicados (hora):",
    de = "Duplikate (Zeit):",
    ["zh-Hans"] = "拍摄时间重复:",
    ["zh-Hant"] = "拍攝時間重複:",
    da = "Tid dubletter:",
  },
  stat_total = {
    ja = "総リスト数:",
    en = "Total list:",
    ko = "총 목록 수:",
    fr = "Total de la liste:",
    es = "Total de lista:",
    de = "Gesamtliste:",
    ["zh-Hans"] = "列表总数:",
    ["zh-Hant"] = "清單總數:",
    da = "Total liste:",
  },
  stat_duplicate_format = {
    ja = "%d枚 (%d組)",
    en = "%d photos (%d groups)",
    ko = "%d장 (%d그룹)",
    fr = "%d photos (%d groupes)",
    es = "%d fotos (%d grupos)",
    de = "%d Fotos (%d Gruppen)",
    ["zh-Hans"] = "%d张 (%d组)",
    ["zh-Hant"] = "%d張 (%d組)",
    da = "%d fotos (%d grupper)",
  },

  -- ========================================
  -- マッチモード
  -- ========================================
  label_match_mode = {
    ja = "マッチ方式:",
    en = "Match by:",
    ko = "일치 방식:",
    fr = "Correspondre par:",
    es = "Coincidir por:",
    de = "Abgleichen nach:",
    ["zh-Hans"] = "匹配方式:",
    ["zh-Hant"] = "匹配方式:",
    da = "Match efter:",
  },
  match_mode_filename = {
    ja = "ファイル名で一致 (FTP)",
    en = "Filename Match (FTP)",
    ko = "파일명 일치 (FTP)",
    fr = "Correspondance par nom (FTP)",
    es = "Coincidencia por nombre (FTP)",
    de = "Dateiname (FTP)",
    ["zh-Hans"] = "按文件名匹配 (FTP)",
    ["zh-Hant"] = "按檔名匹配 (FTP)",
    da = "Filnavn (FTP)",
  },
  match_mode_time = {
    ja = "撮影時刻で推測 (PTP/IP)",
    en = "Capture Time Estimate (PTP/IP)",
    ko = "촬영시간 추정 (PTP/IP)",
    fr = "Estimation par heure (PTP/IP)",
    es = "Estimación por hora (PTP/IP)",
    de = "Aufnahmezeit-Schätzung (PTP/IP)",
    ["zh-Hans"] = "按拍摄时间推测 (PTP/IP)",
    ["zh-Hant"] = "按拍攝時間推測 (PTP/IP)",
    da = "Optagetid-estimat (PTP/IP)",
  },

  -- ========================================
  -- 重複処理
  -- ========================================
  label_duplicate_handling = {
    ja = "重複時の処理:",
    en = "If multiple matches:",
    ko = "중복 시 처리:",
    fr = "Si plusieurs:",
    es = "Si hay múltiples:",
    de = "Bei Mehrfachtreffern:",
    ["zh-Hans"] = "多个匹配时:",
    ["zh-Hant"] = "多個匹配時:",
    da = "Ved flere match:",
  },
  duplicate_handling_first = {
    ja = "ファイル名順 (昇順)",
    en = "Filename (Ascending)",
    ko = "파일명 (오름차순)",
    fr = "Nom de fichier (croissant)",
    es = "Nombre (ascendente)",
    de = "Dateiname (aufsteigend)",
    ["zh-Hans"] = "文件名 (升序)",
    ["zh-Hant"] = "檔名 (升序)",
    da = "Filnavn (stigende)",
  },
  duplicate_handling_skip = {
    ja = "全てスキップ (安全策)",
    en = "Skip all (Safe mode)",
    ko = "모두 건너뛰기 (안전)",
    fr = "Tout ignorer (sûr)",
    es = "Omitir todo (seguro)",
    de = "Alle überspringen (sicher)",
    ["zh-Hans"] = "全部跳过 (安全)",
    ["zh-Hant"] = "全部跳過 (安全)",
    da = "Spring alle over (sikkert)",
  },

  -- ========================================
  -- 警告メッセージ
  -- ========================================
  warning_duplicate = {
    ja = "⚠ 重複マッチ:",
    en = "⚠ Duplicate match:",
    ko = "⚠ 중복 일치:",
    fr = "⚠ Correspondance en double:",
    es = "⚠ Coincidencia duplicada:",
    de = "⚠ Doppelter Treffer:",
    ["zh-Hans"] = "⚠ 重复匹配:",
    ["zh-Hant"] = "⚠ 重複匹配:",
    da = "⚠ Dobbelt match:",
  },
  warning_duplicate_list_title = {
    ja = "重複マッチ詳細:",
    en = "Duplicate Match Details:",
    ko = "중복 일치 상세:",
    fr = "Détails des doublons:",
    es = "Detalles de duplicados:",
    de = "Duplikat-Details:",
    ["zh-Hans"] = "重复匹配详情:",
    ["zh-Hant"] = "重複匹配詳情:",
    da = "Duplikatdetaljer:",
  },
  button_save_csv = {
    ja = "CSV保存...",
    en = "Save CSV...",
    ko = "CSV 저장...",
    fr = "Enregistrer CSV...",
    es = "Guardar CSV...",
    de = "CSV speichern...",
    ["zh-Hans"] = "保存CSV...",
    ["zh-Hant"] = "儲存CSV...",
    da = "Gem CSV...",
  },
  save_csv_title = {
    ja = "重複レポートを保存",
    en = "Save Duplicate Report",
    ko = "중복 보고서 저장",
    fr = "Enregistrer le rapport",
    es = "Guardar informe",
    de = "Bericht speichern",
    ["zh-Hans"] = "保存重复报告",
    ["zh-Hant"] = "儲存重複報告",
    da = "Gem duplikatrapport",
  },
  msg_saved_csv = {
    ja = "CSVファイルを保存しました！",
    en = "CSV file saved!",
    ko = "CSV 파일이 저장되었습니다!",
    fr = "Fichier CSV enregistré!",
    es = "¡Archivo CSV guardado!",
    de = "CSV-Datei gespeichert!",
    ["zh-Hans"] = "CSV文件已保存！",
    ["zh-Hant"] = "CSV檔案已儲存！",
    da = "CSV-fil gemt!",
  },
  
  -- ========================================
  -- ★重要★ 撮影時間マッチモードの警告
  -- ========================================
  warning_time_match_mode = {
    ja = "⚠ 重要: メタデータの反映に誤りが無いか、撮影時刻が重複した画像番号を参照し確認をしてください。",
    en = "⚠ Important: Please verify the accuracy of metadata by checking image numbers with duplicate capture times.",
    ko = "⚠ 중요: 촬영 시간이 중복된 이미지 번호를 확인하여 메타데이터가 올바르게 적용되었는지 반드시 검토해 주세요.",
    fr = "⚠ Important : Veuillez vérifier les images avec des heures de prise identiques pour vous assurer que les métadonnées sont correctement appliquées.",
    es = "⚠ Importante: Por favor verifique las imágenes con tiempos de captura duplicados para asegurar que los metadatos se aplicaron correctamente.",
    de = "⚠ Wichtig: Bitte überprüfen Sie Bilder mit identischer Aufnahmezeit, um sicherzustellen, dass die Metadaten korrekt zugeordnet wurden.",
    ["zh-Hans"] = "⚠ 重要提示：请核对拍摄时间重复的图片编号，确认元数据是否正确应用。",
    ["zh-Hant"] = "⚠ 重要提示：請核對拍攝時間重複的圖片編號，確認中繼資料是否正確套用。",
    da = "⚠ Vigtigt: Kontroller venligst billeder med identiske optagetider for at sikre, at metadata er korrekt anvendt.",
  },

  -- ========================================
  -- エラーメッセージ
  -- ========================================
  error_empty_input = {
    ja = "Selection List が空です。テキストを貼り付けるか、ファイルを読み込んでください。",
    en = "Selection List is empty. Please paste text or load a file.",
    ko = "Selection List가 비어 있습니다.",
    fr = "La liste de sélection est vide.",
    es = "La lista de selección está vacía.",
    de = "Die Auswahlliste ist leer.",
    ["zh-Hans"] = "选择列表为空。",
    ["zh-Hant"] = "選擇清單為空。",
    da = "Udvælgelseslisten er tom.",
  },
  error_no_header = {
    ja = "ヘッダー行が見つかりません。Selection List の形式を確認してください。",
    en = "Header row not found. Please check your Selection List format.",
    ko = "헤더 행을 찾을 수 없습니다.",
    fr = "Ligne d'en-tête introuvable.",
    es = "No se encontró la fila de encabezado.",
    de = "Kopfzeile nicht gefunden.",
    ["zh-Hans"] = "未找到标题行。",
    ["zh-Hant"] = "找不到標題列。",
    da = "Overskriftsrække ikke fundet.",
  },
  error_no_matches = {
    ja = "一致する写真が見つかりませんでした。現在のフォルダまたはコレクションに対象の写真があるか確認してください。",
    en = "No matching photos found. Please check if photos exist in current folder or collection.",
    ko = "일치하는 사진을 찾을 수 없습니다.",
    fr = "Aucune photo correspondante trouvée.",
    es = "No se encontraron fotos coincidentes.",
    de = "Keine passenden Fotos gefunden.",
    ["zh-Hans"] = "未找到匹配的照片。",
    ["zh-Hant"] = "找不到匹配的照片。",
    da = "Ingen matchende fotos fundet.",
  },
  error_no_photos_selected = {
    ja = "写真が選択されていません。フォルダまたはコレクションを選択してください。",
    en = "No photos selected. Please select a folder or collection.",
    ko = "사진이 선택되지 않았습니다.",
    fr = "Aucune photo sélectionnée.",
    es = "No hay fotos seleccionadas.",
    de = "Keine Fotos ausgewählt.",
    ["zh-Hans"] = "未选择照片。",
    ["zh-Hant"] = "未選擇照片。",
    da = "Ingen fotos valgt.",
  },

  -- ========================================
  -- Sync 成功メッセージ
  -- ========================================
  sync_success_title = {
    ja = "同期完了",
    en = "Sync Complete",
    ko = "동기화 완료",
    fr = "Synchronisation terminée",
    es = "Sincronización completada",
    de = "Synchronisation abgeschlossen",
    ["zh-Hans"] = "同步完成",
    ["zh-Hant"] = "同步完成",
    da = "Synkronisering fuldført",
  },
  sync_success_message = {
    ja = "件の写真に rating を同期しました。",
    en = " photos synced successfully.",
    ko = "장의 사진이 동기화되었습니다.",
    fr = " photos synchronisées.",
    es = " fotos sincronizadas.",
    de = " Fotos synchronisiert.",
    ["zh-Hans"] = " 张照片已同步。",
    ["zh-Hant"] = " 張照片已同步。",
    da = " fotos synkroniseret.",
  },

  -- ========================================
  -- 認証ダイアログ
  -- ========================================
  activation_title = {
    ja = "Label Sync – 認証",
    en = "Label Sync – Activation",
    ko = "Label Sync – 활성화",
    fr = "Label Sync – Activation",
    es = "Label Sync – Activación",
    de = "Label Sync – Aktivierung",
    ["zh-Hans"] = "Label Sync – 激活",
    ["zh-Hant"] = "Label Sync – 啟用",
    da = "Label Sync – Aktivering",
  },
  activation_label_code = {
    ja = "ライセンスコード:",
    en = "Activation Code:",
    ko = "라이선스 코드:",
    fr = "Code de licence:",
    es = "Código de licencia:",
    de = "Lizenzcode:",
    ["zh-Hans"] = "许可证代码:",
    ["zh-Hant"] = "授權碼:",
    da = "Licenskode:",
  },
  activation_button_activate = {
    ja = "認証する",
    en = "Activate",
    ko = "활성화",
    fr = "Activer",
    es = "Activar",
    de = "Aktivieren",
    ["zh-Hans"] = "激活",
    ["zh-Hant"] = "啟用",
    da = "Aktiver",
  },
  activation_button_deactivate = {
    ja = "認証解除",
    en = "Deactivate",
    ko = "비활성화",
    fr = "Désactiver",
    es = "Desactivar",
    de = "Deaktivieren",
    ["zh-Hans"] = "停用",
    ["zh-Hant"] = "停用",
    da = "Deaktiver",
  },
  activation_status_not_activated = {
    ja = "未認証",
    en = "Not Activated",
    ko = "미활성",
    fr = "Non activé",
    es = "No activado",
    de = "Nicht aktiviert",
    ["zh-Hans"] = "未激活",
    ["zh-Hant"] = "未啟用",
    da = "Ikke aktiveret",
  },
  trial_status_format = {
    ja = "未認証（トライアル: 残り%d日 / 残り%d枚）",
    en = "Not Activated (Trial: %d days / %d photos left)",
    ko = "미활성 (체험판: %d일 / %d장 남음)",
    fr = "Non activé (Essai: %d jours / %d photos restantes)",
    es = "No activado (Prueba: %d días / %d fotos restantes)",
    de = "Nicht aktiviert (Test: %d Tage / %d Fotos übrig)",
    ["zh-Hans"] = "未激活（试用：剩余%d天 / %d张）",
    ["zh-Hant"] = "未啟用（試用：剩餘%d天 / %d張）",
    da = "Ikke aktiveret (Prøve: %d dage / %d fotos tilbage)",
  },
  trial_expired = {
    ja = "未認証（トライアル期限切れ）",
    en = "Not Activated (Trial Expired)",
    ko = "미활성 (체험 기간 만료)",
    fr = "Non activé (Essai expiré)",
    es = "No activado (Prueba expirada)",
    de = "Nicht aktiviert (Test abgelaufen)",
    ["zh-Hans"] = "未激活（试用已过期）",
    ["zh-Hant"] = "未啟用（試用已過期）",
    da = "Ikke aktiveret (Prøve udløbet)",
  },
  trial_limit_reached = {
    ja = "未認証（処理上限に達しました）",
    en = "Not Activated (Limit Reached)",
    ko = "미활성 (처리 한도 도달)",
    fr = "Non activé (Limite atteinte)",
    es = "No activado (Límite alcanzado)",
    de = "Nicht aktiviert (Limit erreicht)",
    ["zh-Hans"] = "未激活（已达上限）",
    ["zh-Hant"] = "未啟用（已達上限）",
    da = "Ikke aktiveret (Grænse nået)",
  },
  activation_status_activated = {
    ja = "認証済み",
    en = "Activated",
    ko = "활성화됨",
    fr = "Activé",
    es = "Activado",
    de = "Aktiviert",
    ["zh-Hans"] = "已激活",
    ["zh-Hant"] = "已啟用",
    da = "Aktiveret",
  },
  activation_status_trial = {
    ja = "トライアル (7日間)",
    en = "Trial (7 days)",
    ko = "체험판 (7일)",
    fr = "Essai (7 jours)",
    es = "Prueba (7 días)",
    de = "Testversion (7 Tage)",
    ["zh-Hans"] = "试用 (7天)",
    ["zh-Hant"] = "試用 (7天)",
    da = "Prøve (7 dage)",
  },
  activation_error_invalid_code = {
    ja = "無効なコードです。",
    en = "Invalid activation code.",
    ko = "잘못된 코드입니다.",
    fr = "Code invalide.",
    es = "Código inválido.",
    de = "Ungültiger Code.",
    ["zh-Hans"] = "无效的代码。",
    ["zh-Hant"] = "無效的代碼。",
    da = "Ugyldig kode.",
  },
  activation_error_network = {
    ja = "ネットワークエラーが発生しました。",
    en = "Network error occurred.",
    ko = "네트워크 오류가 발생했습니다.",
    fr = "Erreur réseau.",
    es = "Error de red.",
    de = "Netzwerkfehler.",
    ["zh-Hans"] = "网络错误。",
    ["zh-Hant"] = "網路錯誤。",
    da = "Netværksfejl.",
  },
  activation_error_limit_exceeded = {
    ja = "このライセンスは端末上限に達しています。",
    en = "This license has reached its device limit.",
    ko = "이 라이선스는 기기 제한에 도달했습니다.",
    fr = "Cette licence a atteint sa limite d'appareils.",
    es = "Esta licencia ha alcanzado su límite de dispositivos.",
    de = "Diese Lizenz hat ihr Gerätelimit erreicht.",
    ["zh-Hans"] = "此许可证已达到设备上限。",
    ["zh-Hant"] = "此授權已達到裝置上限。",
    da = "Denne licens har nået sin enhedsgrænse.",
  },
  activation_error_revoked = {
    ja = "このライセンスは無効化されています。",
    en = "This license has been revoked.",
    ko = "이 라이선스는 취소되었습니다.",
    fr = "Cette licence a été révoquée.",
    es = "Esta licencia ha sido revocada.",
    de = "Diese Lizenz wurde widerrufen.",
    ["zh-Hans"] = "此许可证已被撤销。",
    ["zh-Hant"] = "此授權已被撤銷。",
    da = "Denne licens er blevet tilbagekaldt.",
  },
  activation_error_expired = {
    ja = "このライセンスは期限切れです。",
    en = "This license has expired.",
    ko = "이 라이선스가 만료되었습니다.",
    fr = "Cette licence a expiré.",
    es = "Esta licencia ha expirado.",
    de = "Diese Lizenz ist abgelaufen.",
    ["zh-Hans"] = "此许可证已过期。",
    ["zh-Hant"] = "此授權已過期。",
    da = "Denne licens er udløbet.",
  },
  activation_upgrade_prompt = {
    ja = "ライセンスを購入しますか？",
    en = "Would you like to purchase a license?",
    ko = "라이선스를 구매하시겠습니까?",
    fr = "Souhaitez-vous acheter une licence?",
    es = "¿Desea comprar una licencia?",
    de = "Möchten Sie eine Lizenz erwerben?",
    ["zh-Hans"] = "是否购买许可证？",
    ["zh-Hant"] = "是否購買授權？",
    da = "Vil du købe en licens?",
  },
  activation_success = {
    ja = "認証に成功しました！",
    en = "Activation successful!",
    ko = "활성화 성공!",
    fr = "Activation réussie!",
    es = "¡Activación exitosa!",
    de = "Aktivierung erfolgreich!",
    ["zh-Hans"] = "激活成功！",
    ["zh-Hant"] = "啟用成功！",
    da = "Aktivering lykkedes!",
  },
  deactivation_confirm_title = {
    ja = "認証解除の確認",
    en = "Confirm Deactivation",
    ko = "비활성화 확인",
    fr = "Confirmer la désactivation",
    es = "Confirmar desactivación",
    de = "Deaktivierung bestätigen",
    ["zh-Hans"] = "确认停用",
    ["zh-Hant"] = "確認停用",
    da = "Bekræft deaktivering",
  },
  deactivation_confirm_message = {
    ja = "この端末の認証を解除しますか？\n他の端末で使用できるようになります。",
    en = "Do you want to deactivate this device?\nYou can then use the license on another device.",
    ko = "이 기기를 비활성화하시겠습니까?\n다른 기기에서 라이선스를 사용할 수 있게 됩니다.",
    fr = "Voulez-vous désactiver cet appareil?\nVous pourrez ensuite utiliser la licence sur un autre appareil.",
    es = "¿Desea desactivar este dispositivo?\nPodrá usar la licencia en otro dispositivo.",
    de = "Möchten Sie dieses Gerät deaktivieren?\nSie können die Lizenz dann auf einem anderen Gerät verwenden.",
    ["zh-Hans"] = "是否停用此设备？\n之后可以在其他设备上使用许可证。",
    ["zh-Hant"] = "是否停用此裝置？\n之後可以在其他裝置上使用授權。",
    da = "Vil du deaktivere denne enhed?\nDu kan derefter bruge licensen på en anden enhed.",
  },
  deactivation_success = {
    ja = "認証を解除しました。",
    en = "Successfully deactivated.",
    ko = "비활성화되었습니다.",
    fr = "Désactivation réussie.",
    es = "Desactivación exitosa.",
    de = "Deaktivierung erfolgreich.",
    ["zh-Hans"] = "停用成功。",
    ["zh-Hant"] = "停用成功。",
    da = "Deaktivering lykkedes.",
  },
  button_yes = {
    ja = "はい",
    en = "Yes",
    ko = "예",
    fr = "Oui",
    es = "Sí",
    de = "Ja",
    ["zh-Hans"] = "是",
    ["zh-Hant"] = "是",
    da = "Ja",
  },
  button_no = {
    ja = "いいえ",
    en = "No",
    ko = "아니오",
    fr = "Non",
    es = "No",
    de = "Nein",
    ["zh-Hans"] = "否",
    ["zh-Hant"] = "否",
    da = "Nej",
  },
  button_visit_website = {
    ja = "🌐 公式サイトを開く",
    en = "🌐 Visit Official Website",
    ko = "🌐 공식 사이트 열기",
    fr = "🌐 Visiter le site officiel",
    es = "🌐 Visitar sitio oficial",
    de = "🌐 Offizielle Website besuchen",
    ["zh-Hans"] = "🌐 访问官方网站",
    ["zh-Hant"] = "🌐 訪問官方網站",
    da = "🌐 Besøg officiel hjemmeside",
  },

  -- ========================================
  -- トライアル制限
  -- ========================================
  trial_limit_title = {
    ja = "試用制限",
    en = "Trial Limit",
    ko = "체험판 제한",
    fr = "Limite d'essai",
    es = "Límite de prueba",
    de = "Testlimit",
    ["zh-Hans"] = "试用限制",
    ["zh-Hant"] = "試用限制",
    da = "Prøvebegrænsning",
  },
  trial_expired_message = {
    ja = "7日間の試用期間が終了しました。\n引き続きご利用いただくには、ライセンスをご購入ください。",
    en = "Your 7-day trial period has ended.\nPlease purchase a license to continue using the plugin.",
    ko = "7일 체험 기간이 종료되었습니다.\n계속 사용하려면 라이선스를 구매하세요.",
    fr = "Votre période d'essai de 7 jours est terminée.\nVeuillez acheter une licence pour continuer.",
    es = "Su período de prueba de 7 días ha terminado.\nCompre una licencia para continuar.",
    de = "Ihre 7-tägige Testphase ist beendet.\nBitte erwerben Sie eine Lizenz um fortzufahren.",
    ["zh-Hans"] = "您的7天试用期已结束。\n请购买许可证以继续使用。",
    ["zh-Hant"] = "您的7天試用期已結束。\n請購買授權以繼續使用。",
    da = "Din 7-dages prøveperiode er udløbet.\nKøb venligst en licens for at fortsætte.",
  },
  photo_limit_reached_message = {
    ja = "試用版の写真処理上限（100枚）に達しました。\n引き続きご利用いただくには、ライセンスをご購入ください。",
    en = "You have reached the trial limit of 100 photos.\nPlease purchase a license to continue.",
    ko = "체험판 사진 한도(100장)에 도달했습니다.\n계속 사용하려면 라이선스를 구매하세요.",
    fr = "Vous avez atteint la limite de 100 photos.\nVeuillez acheter une licence pour continuer.",
    es = "Ha alcanzado el límite de 100 fotos.\nCompre una licencia para continuar.",
    de = "Sie haben das Limit von 100 Fotos erreicht.\nBitte erwerben Sie eine Lizenz um fortzufahren.",
    ["zh-Hans"] = "您已达到100张照片的试用限制。\n请购买许可证以继续使用。",
    ["zh-Hant"] = "您已達到100張照片的試用限制。\n請購買授權以繼續使用。",
    da = "Du har nået grænsen på 100 fotos.\nKøb venligst en licens for at fortsætte.",
  },
  photo_limit_exceeded_message = {
    ja = "処理できる写真の残り枚数: %d枚\n選択した写真数が上限を超えています。",
    en = "Remaining photos: %d\nThe selected photos exceed the limit.",
    ko = "남은 사진 수: %d장\n선택한 사진이 한도를 초과합니다.",
    fr = "Photos restantes: %d\nLes photos sélectionnées dépassent la limite.",
    es = "Fotos restantes: %d\nLas fotos seleccionadas superan el límite.",
    de = "Verbleibende Fotos: %d\nDie ausgewählten Fotos überschreiten das Limit.",
    ["zh-Hans"] = "剩余照片：%d张\n所选照片超过限制。",
    ["zh-Hant"] = "剩餘照片：%d張\n所選照片超過限制。",
    da = "Resterende fotos: %d\nDe valgte fotos overskrider grænsen.",
  },
  trial_status_message = {
    ja = "試用版: 残り%d日 / %d枚",
    en = "Trial: %d days / %d photos remaining",
    ko = "체험판: %d일 / %d장 남음",
    fr = "Essai: %d jours / %d photos restantes",
    es = "Prueba: %d días / %d fotos restantes",
    de = "Test: %d Tage / %d Fotos verbleibend",
    ["zh-Hans"] = "试用：还剩%d天 / %d张",
    ["zh-Hant"] = "試用：還剩%d天 / %d張",
    da = "Prøve: %d dage / %d fotos tilbage",
  },

  -- ========================================
  -- ライセンス期限切れ
  -- ========================================
  license_expired_title = {
    ja = "ライセンス期限切れ",
    en = "License Expired",
    ko = "라이선스 만료",
    fr = "Licence expirée",
    es = "Licencia expirada",
    de = "Lizenz abgelaufen",
    ["zh-Hans"] = "许可证已过期",
    ["zh-Hant"] = "授權已過期",
    da = "Licens udløbet",
  },
  license_expired_message = {
    ja = "ライセンスの有効期限が切れました。\n引き続きご利用いただくには、ライセンスをご購入ください。",
    en = "Your license has expired.\nPlease purchase a license to continue using the plugin.",
    ko = "라이선스가 만료되었습니다.\n계속 사용하려면 라이선스를 구매하세요.",
    fr = "Votre licence a expiré.\nVeuillez acheter une licence pour continuer.",
    es = "Su licencia ha expirado.\nCompre una licencia para continuar.",
    de = "Ihre Lizenz ist abgelaufen.\nBitte erwerben Sie eine Lizenz um fortzufahren.",
    ["zh-Hans"] = "您的许可证已过期。\n请购买许可证以继续使用。",
    ["zh-Hant"] = "您的授權已過期。\n請購買授權以繼續使用。",
    da = "Din licens er udløbet.\nKøb venligst en licens for at fortsætte.",
  },

  -- ========================================
  -- ライセンス種別
  -- ========================================
  license_kind_permanent = {
    ja = "永久ライセンス",
    en = "Permanent License",
    ko = "영구 라이선스",
    fr = "Licence permanente",
    es = "Licencia permanente",
    de = "Permanente Lizenz",
    ["zh-Hans"] = "永久许可证",
    ["zh-Hant"] = "永久授權",
    da = "Permanent licens",
  },
  license_kind_campaign = {
    ja = "β版",
    en = "Beta",
    ko = "베타",
    fr = "Bêta",
    es = "Beta",
    de = "Beta",
    ["zh-Hans"] = "Beta版",
    ["zh-Hant"] = "Beta版",
    da = "Beta",
  },
  license_kind_trial = {
    ja = "トライアル",
    en = "Trial",
    ko = "체험판",
    fr = "Essai",
    es = "Prueba",
    de = "Testversion",
    ["zh-Hans"] = "试用",
    ["zh-Hant"] = "試用",
    da = "Prøve",
  },
  license_expires = {
    ja = "有効期限",
    en = "Expires",
    ko = "만료일",
    fr = "Expire le",
    es = "Expira",
    de = "Läuft ab",
    ["zh-Hans"] = "到期日",
    ["zh-Hant"] = "到期日",
    da = "Udløber",
  },

  -- ========================================
  -- 設定画面
  -- ========================================
  settings_section_title = {
    ja = "設定",
    en = "Settings",
    ko = "설정",
    fr = "Paramètres",
    es = "Configuración",
    de = "Einstellungen",
    ["zh-Hans"] = "设置",
    ["zh-Hant"] = "設定",
    da = "Indstillinger",
  },
  settings_label_language = {
    ja = "言語 / Language:",
    en = "Language:",
    ko = "언어:",
    fr = "Langue:",
    es = "Idioma:",
    de = "Sprache:",
    ["zh-Hans"] = "语言:",
    ["zh-Hant"] = "語言:",
    da = "Sprog:",
  },
  settings_lang_auto = {
    ja = "Auto (System Default)",
    en = "Auto (System Default)",
    ko = "자동 (시스템 기본)",
    fr = "Auto (Défaut système)",
    es = "Auto (Predeterminado del sistema)",
    de = "Auto (Systemstandard)",
    ["zh-Hans"] = "自动 (系统默认)",
    ["zh-Hant"] = "自動 (系統預設)",
    da = "Auto (Systemstandard)",
  },
  settings_restart_note = {
    ja = "※ プラグインを再読み込みすると反映されます",
    en = "* Reload plugin to apply changes",
    ko = "* 플러그인을 다시 로드하여 변경 사항 적용",
    fr = "* Rechargez le plugin pour appliquer les modifications",
    es = "* Recargue el plugin para aplicar los cambios",
    de = "* Plugin neu laden, um Änderungen anzuwenden",
    ["zh-Hans"] = "* 重新加载插件以应用更改",
    ["zh-Hant"] = "* 重新載入外掛程式以套用變更",
    da = "* Genindlæs plugin for at anvende ændringer",
  },
}

return TranslationKeys
